/* Carillon à vent:
Version française de Wind Chimes
*/

/* Wind Chimes 
 by Becky Stewart
 for Adventures in Arduino, Wiley (2015)
 
 Hardware:
 * 1 piezo
 * 5 momentary switches

Copyright 2015 Becky Stewart

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License. 
 */

int timbres[] = {3, 4, 5, 6, 7}; // Le tableau des broches
// des timbres
int nombreTimbres = 5; // Le nombre total de timbres
int brochePiezo = 8; // La broche du haut-parleur
// piézoélectrique

void setup(){
  int i;
  // Appel de pinMode pour tous les timbres
  for(i=0; i<nombreTimbres; i++) {
    pinMode(timbres[i], INPUT_PULLUP);
  }
}

void loop(){
  int i;
  for(i=0; i<nombreTimbres; i++) {
    // Lecture de la valeur de la broche
    int valeur = digitalRead(timbres[i]);
    // Si niveau BAS (LOW signifiant connecté à la masse GND)
    if(valeur == LOW) {
      // Émettre le son
      tone(brochePiezo, (100*i)+200, 30);
      delay(1);
    }
  }
}
